package lib.DAO.Query;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import lib.DAO.ConstUtil;

public abstract class CommonQuery<R> {
	Connection conn = null;
	private String[] schemeAry = null;

	public long selectCount = 0;


	public CommonQuery(String[] schemeAry) {
		this.schemeAry = schemeAry;
	}

	/**
	 * 参照用SQL実行メソッド.
	 * @param sql
	 * @return
	 * @throws SQLException
	 */
	public List<R> executeQuery(String sql) throws SQLException {
		List<R> list;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		selectCount = 0;
		try {
			stmt = conn.prepareStatement(sql);

			rs = stmt.executeQuery();

			list = new ArrayList<R>();

			while(rs.next()) {
				selectCount++;
				list.add(mapRow(rs));
			}
		} finally {
			try {
				if (rs != null) {
					rs.close();
				}
			} finally {
				if (stmt != null) {
					stmt.close();
				}
			}
		}

		return list;
	}

	/**
	 * 更新用SQL実行メソッド.
	 * @param sql
	 * @throws SQLException
	 */
	public int executeUpdate(String sql) throws SQLException {
		int c = 0;
		PreparedStatement preparedStatement = null;

		try {
			preparedStatement = conn.prepareStatement(sql);

			//更新用SQLを実行する
			preparedStatement.executeUpdate();
			c = preparedStatement.getUpdateCount();

		} finally {
			if(preparedStatement!=null){
				//ステートメントを閉じる
				preparedStatement.close();
			}
		}
		return c;
	}

	/**
	 * コネクション取得
	 * @throws Exception
	 */
	public Connection getConnection() throws Exception{
		String db_type = schemeAry[0];
		String host = schemeAry[1];
		String scheme = schemeAry[2];
		String userID = schemeAry[3];
		String pass = schemeAry[4];

		try {
			if(db_type == ConstUtil.DB_ORACLE) {
				Class.forName("oracle.jdbc.driver.OracleDriver");
				conn = DriverManager.getConnection("jdbc:oracle:thin:@"
						+ host + ":1521:" + scheme, userID, pass);

			} else if(db_type == ConstUtil.DB_MYSQL) {
				Class.forName("com.mysql.jdbc.Driver");

				// MySQLの場合
				String url = "jdbc:mysql://" + host + ":3306/" + scheme;
				conn = DriverManager.getConnection(url, userID, pass);
			}

			conn.setAutoCommit(false);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
		return conn;
	}

	/**
	 * コネクション解放
	 * @throws Exception
	 */
	public void closeConnection() throws Exception {
		try {
			if(conn!=null){
				conn.close();
			}
		} finally {
			conn = null;
		}
	}

	/**
	 * SQLにより取得した行を任意の形に成形する
	 */
	public abstract R mapRow(ResultSet rs) throws SQLException;
}
